<?php
// This file is part of Moodle - http://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <http://www.gnu.org/licenses/>.

/**
 * Strings for component 'theme_standard', language 'en', branch 'MOODLE_20_STABLE'
 *
 * @package   theme_contemporary
 * @copyright � 2012 - 2013 | 3i Logic (Pvt) Ltd.
 * @license   http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */
$string['pluginname'] = 'Contemporary';
$string['region-side-post'] = 'Right';
$string['region-side-pre'] = 'Left';
$string['choosereadme'] = '<div class="clearfix"><div class="theme_screenshot"><h2>Contemporary</h2><img src="contemporary/pix/screenshot.jpg" /><h3>Theme Documentation:</h3><p><a href="https://github.com/3ilogiclms/moodle-theme-contemporary-/wiki">https://github.com/3ilogiclms/moodle-theme-contemporary-/wiki </a></p><h3>Report a bug:</h3><p><a href="https://github.com/3ilogiclms/moodle-theme-contemporary-/issues">https://github.com/3ilogiclms/moodle-theme-contemporary-/issues</a></p></div><div class="theme_description"><h2>About</h2><p>Contemporary is a fluid-width, three-column theme for Moodle 2.x. It has a crisp and sophisticated look, and a setting page where you can change your custom banner, link color, footer text and add custom CSS.<h2>Tweaks</h2><p>This theme is built upon both Base and Canvas, two parent themes included in the Moodle core. If you want to modify this theme, we recommend that you first duplicate it then rename it before making your changes. This will prevent your customized theme from being overwritten by future Moodle upgrades, and you will still have the original files if you make a mess. More information on modifying themes can be found in the <a href="http://docs.moodle.org/en/Theme">MoodleDocs</a>.</p><h2>Credits</h2>  <p>This theme is based on Moodle Serenity theme, customized by 3i Logic.</p></div></div>';
$string['banner'] = 'Banner';
$string['bannerdesc'] = 'Upload an image to use as the banner for this site. The banner should be max 1200px wide and 200px long.';
$string['linkcolor'] = 'Link Color';
$string['linkcolordesc'] = 'This sets the link color for the theme.';
$string['blockheadercolor'] = 'Block Header Font Color';
$string['blockheadercolordesc'] = 'This sets the font color of the block header.';
$string['blockheaderbg'] = 'Block Header Background';
$string['blockheaderbgdesc'] = 'This sets the background color for the theme.';
$string['menubg'] = 'Menu Background';
$string['menubgdesc'] = 'This sets the background of menu for the theme.';
$string['menulinkhover'] = 'Menu Link Hover';
$string['menulinkhoverdesc'] = 'This sets the background of menu link hover for the theme.';
$string['menucolor'] = 'Menu Link';
$string['menucolordesc'] = 'This sets the font color of menu for the theme.';
$string['tagline'] = 'Tag Line';
$string['taglinedesc'] = 'The content from this textarea will be displayed under the Site logo on the Homepage';
$string['footertext'] = 'Footer Text';
$string['footertextdesc'] = 'The content from this textarea will be displayed in the footer of every page. E.g: your copyright info.';
$string['customcss'] = 'Custom CSS';
$string['customcssdesc'] = 'Any CSS you enter here will be added to every page allowing your to easily customise this theme.';
